function [K,gamma_c] = Controller_design(A,B,D)

[n,m] = size(B);
[~,r] = size(D);

% uncertainty
Mc = eye(n);
Nc = 0.1*A;
C0 = eye(n);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
gamma0 = sdpvar(1);
M0 = sdpvar(m,n);
P0 = sdpvar(n,n);

LMI1 = blkvar();
LMI1(1,1) = (A*P0+B*M0)+(A*P0+B*M0)';
LMI1(1,2) = D;
LMI1(1,3) = Mc;
LMI1(1,4) = P0*Nc';
LMI1(1,5) = P0*C0';

LMI1(2,2) = -gamma0*eye(r);
LMI1(2,3) = zeros(r,n);
LMI1(2,4) = zeros(r,n);
LMI1(2,5) = zeros(r,n);

LMI1(3,3) = -eye(n);
LMI1(3,4) = zeros(n,n);
LMI1(3,5) = zeros(n,n);

LMI1(4,4) = -eye(n);
LMI1(4,5) = zeros(n,n);

LMI1(5,5) = -gamma0*eye(n);

LMI1 = sdpvar(LMI1);


const = [];
objective = 1.0e-6*gamma0;

const = [const, P0 >= eps*eye(n)];
const = [const, gamma0 >= 0];
const = [const, LMI1 <= -eps*eye(4*n+r)];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
ops = sdpsettings('solver','mosek','verbose','1');
optimize(const,objective,ops);

K =  value(M0)*inv(value(P0));
gamma_c = value(gamma0);




